#ifndef ZMODELER_STRUCT_CCURVE_EDIT_INCLUDED
#define ZMODELER_STRUCT_CCURVE_EDIT_INCLUDED

//------------------------------------------------------------------
//
//  Generic GDI Curve edit view. Used in animation and other stuff
//
//------------------------------------------------------------------
#define MAX_CONTROL_POINTS              20

#define CURVE_DRAW_CONTROL_POINTS       0x0001
#define CURVE_DRAW_CONTROL_POSITIONS    0x0002
#define CURVE_DRAW_CONNECT_POINTS       0x0004

#define CURVE_DRAW_BIG_POINTS           0x0010
#define CURVE_DRAW_HUGE_POINTS          0x0020
#define CURVE_DRAW_COLORED_POSITIONS    0x0040
#define CURVE_DRAW_SOLID_POSITIONS      0x0080

#define CURVE_NO_COLOR_ON_LBD           0x0100
#define CURVE_NO_DRAG_POINTS            0x0200
#define CURVE_NO_DRAG_POSITIONS         0x0400
#define CURVE_NO_ACTIVE_POSITIONS       0x1000
#define CURVE_NO_ACTIVE_POINTS          0x2000


class DllExport CCurveEdit : public CView
{
public:
  float* fControlPoints[MAX_CONTROL_POINTS]; //positions;
  float* fControlValues[MAX_CONTROL_POINTS]; //values;
  long*  lControlPoints[MAX_CONTROL_POINTS]; //positions;
  long*  lControlValues[MAX_CONTROL_POINTS]; //values;
  DWORD* dwControlColors[MAX_CONTROL_POINTS];

  tPOINT fWidthRange;
  POINT  lWidthRange;
  tPOINT fHeightRange;
  POINT  lHeightRange;

public:
  CCurveEdit();
  virtual ~CCurveEdit();
public:
  long NumControlPoints;
  long ScreenWidth;
  long ScreenHeight;

  long currValue;
  long currPos;

public:
  void OnDraw(CDC* pdc);
  void SetWidth(float w); //total width.
  void SetHeight(float h);//total height.

  DWORD     nCurveFlags;

  tPOINT2D  GetControlPoint(short index);
  void      SetControlPoint(tPOINT2D point, short index);

public:
  afx_msg void OnMouseMove(UINT nFlags, CPoint loc);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint loc);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint loc);

  afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);

  DECLARE_MESSAGE_MAP()
};

#endif

